<?php
/**
 * Plugin Name:           AutomatorWP - LearnPress
 * Plugin URI:            https://automatorwp.com/add-ons/learnpress/
 * Description:           Connect AutomatorWP with LearnPress.
 * Version:               1.1.5
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-learnpress
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.7
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\LearnPress
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_LearnPress {

    /**
     * @var         AutomatorWP_LearnPress $instance The one true AutomatorWP_LearnPress
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_LearnPress self::$instance The one true AutomatorWP_LearnPress
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_LearnPress();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_LEARNPRESS_VER', '1.1.5' );

        // Plugin file
        define( 'AUTOMATORWP_LEARNPRESS_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_LEARNPRESS_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_LEARNPRESS_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Triggers
            require_once AUTOMATORWP_LEARNPRESS_DIR . 'includes/triggers/complete-quiz.php';
            require_once AUTOMATORWP_LEARNPRESS_DIR . 'includes/triggers/complete-lesson.php';
            require_once AUTOMATORWP_LEARNPRESS_DIR . 'includes/triggers/enroll-course.php';
            require_once AUTOMATORWP_LEARNPRESS_DIR . 'includes/triggers/complete-course.php';

            // Actions
            require_once AUTOMATORWP_LEARNPRESS_DIR . 'includes/actions/user-course.php';
            require_once AUTOMATORWP_LEARNPRESS_DIR . 'includes/actions/mark-lesson.php';
            require_once AUTOMATORWP_LEARNPRESS_DIR . 'includes/actions/mark-course.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'learnpress', array(
            'label' => 'LearnPress',
            'icon'  => AUTOMATORWP_LEARNPRESS_URL . 'assets/learnpress.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'LearnPress' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_LearnPress instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_LearnPress The one true AutomatorWP_LearnPress
 */
function AutomatorWP_LearnPress() {
    return AutomatorWP_LearnPress::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_LearnPress' );
